#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>

typedef long long ll;


typedef struct Node {
    ll key;
    int cnt;
    struct Node* next;
} Node;

#define HASH_SIZE (1<<20)

Node* hash1[HASH_SIZE];
Node* hash2[HASH_SIZE];

unsigned long long h(ll x){ 
    x ^= x >> 33;
    x *= 0xff51afd7ed558ccdULL;
    x ^= x >> 33;
    return x & (HASH_SIZE-1);
}

void add(Node** H, ll key){
    unsigned long long id = h(key);
    Node* p = H[id];
    while(p){
        if(p->key == key){ p->cnt++; return; }
        p = p->next;
    }
    Node* q = malloc(sizeof(Node));
    q->key = key;
    q->cnt = 1;
    q->next = H[id];
    H[id] = q;
}

ll comb2(ll x){
    return x < 2 ? 0 : x*(x-1)/2;
}

int main(){
    int N;
    scanf("%d", &N);



    for(int i=0;i<N;i++){
        ll x,y;
        scanf("%lld %lld",&x,&y);

        ll key1 = y*2 + ( (x&1) != 0 );
        add(hash1, key1);

        ll key2 = x*2 + ( (y&1) != 0 );
        add(hash1, key2 + ((ll)1<<62)); 

        ll d = x - y;
        add(hash2, d);

        ll s = x + y;
        add(hash2, s + ((ll)1<<62));
    }

    ll ans = 0;

    
    for(int i=0;i<HASH_SIZE;i++){
        Node* p = hash1[i];
        while(p){
            ans += comb2(p->cnt);
            p = p->next;
        }
    }

    
    for(int i=0;i<HASH_SIZE;i++){
        Node* p = hash2[i];
        while(p){
            ans += comb2(p->cnt);
            p = p->next;
        }
    }

    printf("%lld\n", ans);

    return 0;
}